from bericht import Bericht
class Gebruiker:
    def __init__(self, gebruikersnaam, bio=""):
        self.gebruikersnaam = gebruikersnaam
        self.bio = bio
        self.volgers = []
        self.berichten = []

    # getters
    def get_gebruikersnaam(self):
        return self.gebruikersnaam

    def get_bio(self):
        return self.bio

    def get_volgers(self):
        return self.volgers

    def get_posts(self):
        return self.berichten

    # setters
    def set_gebruikersnaam(self, nieuwe_gebruikersnaam):
        self.gebruikersnaam = nieuwe_gebruikersnaam

    def set_bio(self, nieuwe_bio):
        self.bio = nieuwe_bio

    def set_volgers(self, nieuwe_volgers):
        self.volgers = nieuwe_volgers

    def set_bericht(self, nieuw_bericht):
        self.berichten = nieuw_bericht

    # methodes
    def maak_bericht(self, titel, tekst):
        self.berichten.append(Bericht(self, titel, tekst))

    def toon_berichten(self):
        for bericht in self.berichten:
            bericht.toon_bericht()

    def toon_profiel(self):
        if len(self.berichten) == 0:
            print(f"\nGebruikersnaam: {self.gebruikersnaam}\nVolgers: {len(self.volgers)}\nBerichten: Deze gebruiker heeft nog geen berichten geplaatst.")
        else:
            print(f"\nGebruikersnaam: {self.gebruikersnaam}\nVolgers: {len(self.volgers)}\nBerichten:\n")
            self.toon_berichten()

    def nieuwe_volger(self, andere_gebruiker):
        self.volgers.append(andere_gebruiker)